use master
GO

set nocount on 

--set to 0 to skip updating the A4Survey_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @ClientPayload01 nvarchar(max) = N'
-- DEV-93041  702001
-- Message 5216: SurveyTerminationMessageHeader
IF DB_NAME() <> ''Acuity4_Public_Content'' AND NOT EXISTS (SELECT * FROM [SAT].[MessageCodes] WHERE [Id] = 5216)
BEGIN
	INSERT [SAT].[MessageCodes] ([Id], [Name]) VALUES (5216, N''SurveyTerminationMessageHeader'')
	EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5216, ''en'', N''Survey Termination''
	EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5216, ''fr'', N''Fin d''''enqute''
END
'

declare @ClientPayload02 nvarchar(max) = N'
-- Message 5217: QuotaMet/ClosedMessageHeader
IF DB_NAME() <> ''Acuity4_Public_Content'' AND NOT EXISTS (SELECT * FROM [SAT].[MessageCodes] WHERE [Id] = 5217)
BEGIN
	INSERT [SAT].[MessageCodes] ([Id], [Name]) VALUES (5217, N''QuotaMetClosedMessageHeader'')
	EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5217, ''en'', N''Quota Met/Closed''
	EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5217, ''fr'', N''Quota atteint/ferm''
END
'

declare @ClientPayload03 nvarchar(max) = N'
-- Message 5218: CompletedMessageHeader
IF DB_NAME() <> ''Acuity4_Public_Content'' AND NOT EXISTS (SELECT * FROM [SAT].[MessageCodes] WHERE [Id] = 5218)
BEGIN
	INSERT [SAT].[MessageCodes] ([Id], [Name]) VALUES (5218, N''CompletedMessageHeader'')
	EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5218, ''en'', N''Survey completed''
	EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5218, ''fr'', N''Sondage complt''
END
'

declare @ClientPayload04 nvarchar(max) = N'
-- Message 5219: ScreenedOutMessageHeader
IF DB_NAME() <> ''Acuity4_Public_Content'' AND NOT EXISTS (SELECT * FROM [SAT].[MessageCodes] WHERE [Id] = 5219)
BEGIN
	INSERT [SAT].[MessageCodes] ([Id], [Name]) VALUES (5219, N''ScreenedOutMessageHeader'')
	EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5219, ''en'', N''Screened Out''
	EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5219, ''fr'', N''Rpondant limin''
END
'

declare @ClientPayload05 nvarchar(max) = N'
-- Message 5220: InterruptedMessageHeader
IF DB_NAME() <> ''Acuity4_Public_Content'' AND NOT EXISTS (SELECT * FROM [SAT].[MessageCodes] WHERE [Id] = 5220)
BEGIN
	INSERT [SAT].[MessageCodes] ([Id], [Name]) VALUES (5220, N''InterruptedMessageHeader'')
	EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5220, ''en'', N''Survey interrupted''
	EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5220, ''fr'', N''Sondage interrompu''
END
'

declare @ClientPayload06 nvarchar(max) = N'
-- Message 5221: TimerTerminationMessageHeader
IF DB_NAME() <> ''Acuity4_Public_Content'' AND NOT EXISTS (SELECT * FROM [SAT].[MessageCodes] WHERE [Id] = 5221)
BEGIN
	INSERT [SAT].[MessageCodes] ([Id], [Name]) VALUES (5221, N''TimerTerminationMessageHeader'')
	EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5221, ''en'', N''Timer Termination''
	EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5221, ''fr'', N''Fin du chronomtre''
END
'

declare @ClientPayload07 nvarchar(max) = N'
-- DEV-93041  702002
IF DB_NAME() <> ''Acuity4_Public_Content''
BEGIN

    EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5216, ''en'', N''Survey Completed''
	EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5216, ''fr'', N''Sondage termin''

    EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5217, ''en'', N''Survey Completed''
	EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5217, ''fr'', N''Sondage termin''

    EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5218, ''en'', N''Survey Completed''
	EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5218, ''fr'', N''Sondage complt''

    EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5219, ''en'', N''Survey Closed''
	EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5219, ''fr'', N''Sondage termin''

    EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5220, ''en'', N''Survey Interrupted''
	EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5220, ''fr'', N''Sondage interrompu''
END
'

declare @ClientPayload08 nvarchar(max) = N'
-- DEV-93041  702003
--- Message 5221: TimerTerminationMessageHeader 
IF DB_NAME() <> ''Acuity4_Public_Content'' AND 
   EXISTS (SELECT 1 FROM [SAT].[DefaultMessageTexts] WHERE ErrorMessageId = 5221)
BEGIN
    DELETE FROM [SAT].[DefaultMessageTexts] WHERE ErrorMessageId = 5221;
END
'

declare @ClientPayload09 nvarchar(max) = N'
IF DB_NAME() <> ''Acuity4_Public_Content'' AND 
   EXISTS (SELECT 1 FROM [SAT].[LocalizableTexts_QuestionnaireMessageText] WHERE ErrorMessageId = 5221)
BEGIN
    DELETE FROM [SAT].[LocalizableTexts_QuestionnaireMessageText] WHERE ErrorMessageId = 5221;
END
'

declare @ClientPayload10 nvarchar(max) = N'
IF DB_NAME() <> ''Acuity4_Public_Content'' AND 
   EXISTS (SELECT 1 FROM [SAT].[MessageCodes] WHERE Id = 5221)
BEGIN
    DELETE FROM [SAT].[MessageCodes] WHERE Id = 5221;
END
'

declare @ClientPayload11 nvarchar(max) = N'
-- DEV-93041  702004
IF DB_NAME() <> ''Acuity4_Public_Content''
BEGIN
	EXEC [SAT].VX_sp_CreateOrUpdateDefaultMessageText 5218, ''fr'', N''Sondage termin''
END
'

declare @ClientPayload12 nvarchar(max) = N'
-- DEV-93606  702012
IF NOT EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[SurveyProviderIds]'') AND type IN (N''U''))
BEGIN
	CREATE TABLE [dbo].[SurveyProviderIds]
	(
		[Id] int NOT NULL IDENTITY(1,1),
		[SurveyProviderId] int NOT NULL,
		[ProviderId] nvarchar(max) NOT NULL,
		CONSTRAINT [PK_SurveyProviderIds] PRIMARY KEY CLUSTERED ([Id]),
		CONSTRAINT [FK_SurveyProviderIds_SurveyProviders] FOREIGN KEY ([SurveyProviderId]) 
			REFERENCES [dbo].[SurveyProviders]([Id])
			ON DELETE CASCADE
	)
END
'

declare @ClientPayload13 nvarchar(max) = N'
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE object_id = OBJECT_ID(N''[dbo].[SurveyProviderIds]'') AND name = N''IX_SurveyProviderIds_SurveyProviderId'')
BEGIN
    CREATE NONCLUSTERED INDEX [IX_SurveyProviderIds_SurveyProviderId]
    ON [dbo].[SurveyProviderIds] ([SurveyProviderId])
END
'

declare @ClientPayload14 nvarchar(max) = N'
-- Migration from ProviderIdList to SurveyProviderIds
IF EXISTS (SELECT 1 FROM sys.columns WHERE object_id = OBJECT_ID(''[dbo].[SurveyProviders]'') AND name = N''ProviderIdList'')
BEGIN
	EXEC sp_executesql N''
	DECLARE @SurveyProviderId INT
	DECLARE @ProviderIdList NVARCHAR(MAX)

	DECLARE providerCursor CURSOR FOR
	SELECT [Id], [ProviderIdList]
	FROM [dbo].[SurveyProviders]
	WHERE LEN([ProviderIdList]) > 0

	OPEN providerCursor
	FETCH NEXT FROM providerCursor INTO @SurveyProviderId, @ProviderIdList

	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE @ProviderId NVARCHAR(MAX)
		DECLARE @StartPos INT = 1
		DECLARE @EndPos INT

		SET @ProviderIdList = REPLACE(@ProviderIdList, CHAR(13), '''''''') -- 13 = \r
		
		WHILE @StartPos <= LEN(@ProviderIdList)
		BEGIN
			SET @EndPos = CHARINDEX(CHAR(10), @ProviderIdList, @StartPos) -- 10 = \n
			
			IF @EndPos = 0
				SET @EndPos = LEN(@ProviderIdList) + 1
			
			SET @ProviderId = LTRIM(RTRIM(SUBSTRING(@ProviderIdList, @StartPos, @EndPos - @StartPos)))
			
			IF LEN(@ProviderId) > 0
			BEGIN
				INSERT INTO [dbo].[SurveyProviderIds] ([SurveyProviderId], [ProviderId])
				VALUES (@SurveyProviderId, @ProviderId)
			END
			
			SET @StartPos = @EndPos + 1
		END

		FETCH NEXT FROM providerCursor INTO @SurveyProviderId, @ProviderIdList
	END

	CLOSE providerCursor
	DEALLOCATE providerCursor
	''

	ALTER TABLE [dbo].[SurveyProviders]
	DROP COLUMN [ProviderIdList]
END
'

--declare @SurveyPayload01 nvarchar(max) = N'waitfor delay ''0:00:01'''

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)
create table #Survey (
	DBName nvarchar(128),
	SchemaName nvarchar(128),
	Processed tinyint default 0
)
create table #SurveyVerif (
	DBName nvarchar(128),
	SchemaName nvarchar(128)
)
create table #SurveysDone (
	DBName nvarchar(128) collate database_default,
	SchemaName nvarchar(128) collate database_default
)
declare @AllDone bit = 0, 
        @TotalClients int, 
		@TotalSurveys int, 
		@ClientCounter int, 
		@SurveyCounter int, 
		@ThisClient nvarchar(128), 
		@ThisSurvey nvarchar(128), 
		@ClientCursor cursor, 
		@SurveyCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalClients = 0, @TotalSurveys = 0, @ClientCounter = 0, @SurveyCounter = 0
	insert into #DB 
	select 'A4Survey_Client_' + cast(Id as nvarchar(16)), 0 from Acuity4.dbo.Client
	     
    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Survey_Client_Template', 0)

	select @TotalClients = count(*) 
	       from #DB
	
	set @ClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @ClientCursor
	fetch next from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @ClientCounter += 1
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #Survey select ''' + @ThisClient + ''', SchemaName, 0 from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName, 0 from #SurveysDone'
		exec @DBSQL @SQL
		select @StatusMessage = 'Updating client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ClientCounter / @TotalClients
		raiserror (@StatusMessage, 0, 1, @ThisClient, @ClientCounter, @TotalClients, @StatusPercent) with nowait
		
		print 'Client Payload 1'
		select @SQL = replace(replace(@ClientPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 2'
		select @SQL = replace(replace(@ClientPayload02, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 3'
		select @SQL = replace(replace(@ClientPayload03, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 4'
		select @SQL = replace(replace(@ClientPayload04, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 5'
		select @SQL = replace(replace(@ClientPayload05, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 6'
		select @SQL = replace(replace(@ClientPayload06, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 7'
		select @SQL = replace(replace(@ClientPayload07, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 8'
		select @SQL = replace(replace(@ClientPayload08, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 9'
		select @SQL = replace(replace(@ClientPayload09, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 10'
		select @SQL = replace(replace(@ClientPayload10, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 11'
		select @SQL = replace(replace(@ClientPayload11, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 12'
		select @SQL = replace(replace(@ClientPayload12, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 13'
		select @SQL = replace(replace(@ClientPayload13, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 14'
		select @SQL = replace(replace(@ClientPayload14, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'All Client Payload done for  client ' + @ThisClient + '!'

		update #DB set Processed = 1 where current of @ClientCursor
		fetch next from @ClientCursor into @ThisClient
	end


	close @ClientCursor
	deallocate @ClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Survey_Client_Template';
      SET @SQL = 'USE Acuity4;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
drop table #Survey
drop table #SurveyVerif
drop table #SurveysDone